% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program CSFstd.m
function [Gmax_std, Fmax_std, beta_std, delta_std] =     CSFstd(CSF0)  

Nfrequencies = size(CSF0, 2)
Gmax0 = []; Fmax0 = []; beta0=[]; delta0=[];
for i = 1 : 1000
  CSF=[CSF0(1,:); CSF0(2, :) + CSF0(3, :).*randn(1, ...
      Nfrequencies)];
  
  [Gmax, Fmax, beta, delta, r2] = fittingCSF(CSF);
  Gmax0 = [Gmax0; Gmax];
  Fmax0 = [Fmax0; Fmax];
  beta0 = [beta0; beta];
  delta0 = [delta0; delta];
end

Gmax_std = std(Gmax0);
Fmax_std = std(Fmax0);
beta_std = std(beta0);
delta_std = std(delta0);
